using System;
using System.Collections.Generic;
using System.Linq;

class Poncho
{
    public int index;
    public long w, v;
    public double ratio;
}

class Program
{
    static void Main()
    {
        var first = Console.ReadLine().Split();
        int N = int.Parse(first[0]);
        long W = long.Parse(first[1]);
        double eps = double.Parse(first[2]);

        var ponchos = new List<Poncho>();

        for (int i = 1; i <= N; i++)
        {
            var line = Console.ReadLine().Split();
            long w = long.Parse(line[0]);
            long v = long.Parse(line[1]);

            ponchos.Add(new Poncho
            {
                index = i,
                w = w,
                v = v,
                ratio = (double)v / w
            });
        }

        ponchos.Sort((a, b) => b.ratio.CompareTo(a.ratio));

        long totalWeight = 0;
        long totalValue = 0;
        var chosen = new List<int>();

        foreach (var p in ponchos)
        {
            if (totalWeight + p.w <= W)
            {
                totalWeight += p.w;
                totalValue += p.v;
                chosen.Add(p.index);
            }
        }

        Console.WriteLine(chosen.Count);
        chosen.Sort();
        if (chosen.Count > 0)
            Console.WriteLine(string.Join(" ", chosen));
    }
}